var spaghettiSplat1:FlxSprite = new FlxSprite();
var spaghettiSplat3:FlxSprite = new FlxSprite();
spaghettiSplat1.frames = Paths.getFrames("game/mechanics/weegee/Spaghetti_Initial_Splat");
spaghettiSplat3.frames = Paths.getFrames("game/mechanics/weegee/Green_Splat_Flash");
spaghettiSplat1.animation.addByPrefix("splat", "Spaghetti Splat instance ", 24, false);
spaghettiSplat3.animation.addByPrefix("flash", "Splat Green Flash instance ", 24, false);

var theSound:FlxSound;
theSound = FlxG.sound.load(Paths.sound("spaghettiNote"));
var timeout:FlxTimer = new FlxTimer();


function postCreate () {
    
    for (i in [spaghettiSplat1, spaghettiSplat3]) {
        i.antialiasing = true;
        i.screenCenter();
        i.cameras = [camHUD];
        i.visible = false;
        i.scale.set(0.9, 0.9);
        add(i);
    }
}

function splatAnimations () {
    spaghettiSplat3.visible = false;
    spaghettiSplat1.visible = true;
    spaghettiSplat1.animation.play('splat');

    timeout.start(2, () ->
	{
        spaghettiSplat1.visible = false;
        spaghettiSplat3.visible = true;
        spaghettiSplat3.animation.play('flash');
	});

}

function onPlayerHit(e) {
    if (e.noteType == "Spag Note"){
        trace("splat");
        health -= .1;
        theSound.play(true);
        e.healthGain = 0;
        timeout.reset();
        if (!spaghettiSplat1.visible) splatAnimations();
    }
}

function onDadHit(e) {
    if (e.noteType == "Spag Note"){
        e.cancel();
    }
}

function onPlayerMiss(e) {
	if (e.noteType == "Spag Note"){
		e.cancel();
		deleteNote(e.note);
	}
}
function onNoteCreation(event) {
    if (event.noteType == "Spag Note"){
        event.cancel(true);
        
        event.note.frames = Paths.getFrames("game/mechanics/weegee/spaghetti");
        switch(event.strumID % 4) {
            case 0: event.note.animation.addByPrefix('scroll', 'purple');
            case 1: event.note.animation.addByPrefix('scroll', 'blue');
            case 2: event.note.animation.addByPrefix('scroll', 'green');
            case 3: event.note.animation.addByPrefix('scroll', 'red');
        }
        event.note.antialiasing = true;
        event.note.scale.set(event.noteScale, event.noteScale);
        event.note.latePressWindow = 0.3;
        event.note.earlyPressWindow = 0.3;
        
	}
    
}
function onPostNoteCreation(e) {
    if (e.noteType == "Spag Note"){
        e.note.offset.set(30, -50);
	}
}
